#include "commonheaders.h"
#include "cls-window.h"
#include "cls-windraw.h"

Label::Label(short xLocation, short yLocation, char *text) {
    xPos = xLocation;
    yPos = yLocation;
    label = (char *)qualloc(strlen(text)+1);
    Init_String(label, text, 0);

    image = NULL;
}
Label::Label(short xLocation, short yLocation, BITMAP *mainImage) {
    xPos = xLocation;
    yPos = yLocation;
    image = mainImage;
    
    label = NULL;
}
void Label::SetText(char *text) {
    label = (char *)qualloc(strlen(text)+1);
    Init_String(label, text, 0);
}
void Label::SetImage(BITMAP *mainImage) {
    image = mainImage;
}
void Label::Draw(BITMAP *output, short xLocation, short yLocation) {
    if(label != NULL) {
        textprintf(output, font, xPos + xLocation + 1, yPos + yLocation + 1, BLACK, label);
        textprintf(output, font, xPos + xLocation, yPos + yLocation, WHITE, label);
    } else {
        draw_sprite(output, image, xPos + xLocation, yPos + yLocation);
    }
}
